﻿using System;
using PostitCore;
using PostitCommon;
using System.Collections.Generic;
using Newtonsoft.Json;
using System.Net.Http;

namespace DeXGets
{
    public class LearnerIdentifiers : BaseClass
    {
        public class LearnerIdentifiers_Response
        {
            public Guid ExternalID;
            public string Forename;
            public string Surname;
            public string GenderCategory;
            public string OnRollState;
            public BaseLookups CurrentYearGroup;
            public BaseLookups CurrentPrimaryClass;
            // The properties below are commented because they weren't needed for the sample app
            // SImply uncomment them and add them to the list of fields in 
            // URL_LearnerIdentifier = SetURL("Learner", "LearnerIdentifiers?$select=ExternalID,Forename,Surname,GenderCategory,OnRollState,CurrentYearGroup,CurrentPrimaryClass&");
            // As appropriate.
            //    public int? AgeMonths;
            //    public string Photograph;
            //    public bool? DoNotCommunicate;
            //    public BaseLookups CurrentHouse;
            //    public DateTime? DateOfApplication;
        }
        /// <summary>
        /// Returns the set of contact contact basics
        /// </summary>
        /// <param name="token"></param>
        /// <param name="key"></param>
        /// <param name="httpClient"></param>
        /// <returns></returns>
        public Dictionary<Guid, LearnerIdentifiers_Response> GetValues(string token, string key, HttpClient httpClient)
        {
            Dictionary<Guid, LearnerIdentifiers_Response> values = new Dictionary<Guid, LearnerIdentifiers_Response>();
            string URL_LearnerIdentifier = SetURL("Learner", "LearnerIdentifiers?$filter=OnRollState eq 'Current'&$select=ExternalID,Forename,Surname,GenderCategory,OnRollState,CurrentYearGroup,CurrentPrimaryClass&");
            string resp = DoCall(URL_LearnerIdentifier, token, httpClient, key);
            ODataResponse<LearnerIdentifiers_Response> learners = null;
            try
            {
                learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LearnerIdentifiers_Response>>(resp);
                foreach (LearnerIdentifiers_Response s in learners.Value)
                {
                    values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(learners.NextLink))
                {
                    resp = DoCall(GetNextLink(learners.NextLink), token, httpClient, key);
                    learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LearnerIdentifiers_Response>>(resp);
                    foreach (LearnerIdentifiers_Response s in learners.Value)
                    {
                        values.Add(s.ExternalID, s);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}
